%% ======================================================================
%%  dynamic_tau_filter  — Patton‑type time‑varying threshold             
%% ======================================================================
function res = dynamic_tau_filter(y, omega, beta, a1, a2, f1, kappa, steep, sharp)
    if nargin<7, kappa = 0.1; end
    if nargin<8, steep = 3; end
    if nargin<9, sharp = false; end
    T = numel(y);
    f  = zeros(T,1); llik = 0;
    for t = 1:T
        f(t) = f1;
        PoT  = y(t) - f1;
        if sharp
            sig = double(PoT>0);
        else
            sig = 1 ./ (1 + exp(-steep*PoT));
        end
        llik = llik - kappa*(1-sig)*PoT + (1-kappa)*sig*PoT;
        f1   = omega + beta*f1 - a1*(-(1-kappa)*sig + kappa*(1-sig) - sig*(1-sig)*PoT*steep);
                      + a2*sig*PoT;
    end
    if ~isfinite(llik), llik = 1e10; end
    res = struct('llik', llik/T, 'f_out', f);
end