%% ======================================================================
function out = estimate_full_model(my_data, EVT_OPTIONS, varargin)
%ESTIMATE_FULL_MODEL  Joint tau + tail filter.
    p=inputParser; addParameter(p,'smoothings',[5 20 -1]); addParameter(p,'verbosity',0); addParameter(p,'lower_tail',false); parse(p,varargin{:}); S=p.Results;

    %tailMult = tern(S.lower_tail,1,-1);
    %y = tailMult * my_data.y;

    if ~isfield(EVT_OPTIONS,'TAU_TAIL_PCT'), EVT_OPTIONS.TAU_TAIL_PCT = 0.05; end
    kappa = EVT_OPTIONS.TAU_TAIL_PCT;

    %% ------------ parameters you may want to tune -----------------------
    maxTauIter   = 50;                       % hard stop after N failed tries
    thetaSeeds   = [ ...                     % deterministic seed list (rows)
        0.05  0.9  0.5  0.5 ;                %   1)   original paper default
        0.05  0.9  0.5  0.5 ;                 %   2)   mild persistence
        0.05  0.9  0.5  0.5 ;                %   3)   stronger mean‑reversion
        0.1  0.9  0.9  0.5 ];                %   4)   higher unconditional var
    extraJitter  = 0.15;                     % std‑dev for *random* seeds
    baseTheta0   = [0.5  0.9  0.5  0];      % used once seeds are exhausted
    %% -------------------------------------------------------------------

    tau_ok   = false;
    tau_iter = 0;         % counts attempts
    seed_idx = 0;         % position in thetaSeeds

    % while ~tau_ok && tau_iter < maxTauIter
    %     tau_iter = tau_iter + 1;
    % 
    %     % -------- choose a fresh starting point (theta0) -----------------
    %     seed_idx  = seed_idx + 1;
    %     if seed_idx <= size(thetaSeeds,1)
    %         theta0 = thetaSeeds(seed_idx ,:);
    %     else
    %         % all predefined seeds have failed –> draw a random one
    %         theta0 = baseTheta0 + extraJitter*randn(size(baseTheta0));
    %     end
    % 
    %     % -------- estimate dynamic τ with that theta0 --------------------
    %     if ~isfield(EVT_OPTIONS,'EXTERNAL_TAU') || isempty(EVT_OPTIONS.EXTERNAL_TAU)
    % 
    %         for steep = S.smoothings
    %             sharp = steep<0; if sharp, steep = max(S.smoothings); end
    %             obj  = @(th)local_tau_filter(y,th,kappa,steep,sharp);
    % 
    %             if sharp
    %                 theta0 = fminsearch(obj,theta0,...
    %                     optimset('Display','off','MaxIter',2000));
    %             else
    %                 if exist('fminunc','file')
    %                     theta0 = fminunc(obj,theta0,...
    %                         optimoptions('fminunc','Display','off',...
    %                         'MaxIter',500,'Algorithm','quasi-newton'));
    %                 else
    %                     theta0 = fminsearch(obj,theta0,...
    %                         optimset('Display','off','MaxIter',500));
    %                 end
    %             end
    %         end
    % 
    %         p       = par_trafo_tau(theta0);
    %         tau_path = dynamic_tau_filter(y, p.omega, p.beta,...
    %             p.alpha1, p.alpha2,...
    %             quantile(y,1-kappa), kappa, 3, false).f_out ...
    %             * tailMult;
    %         % -------- check positivity of tau_pos ----------------------------
    %         tau_pos = tailMult * tau_path;
    %         tau_ok  = all(tau_pos > 0);
    % 
    %     else
    %         tau_path = EVT_OPTIONS.EXTERNAL_TAU;
    %         tau_pos  = tau_path;
    %         tau_ok  = all(tau_pos > 0);
    %     end
    % 
    %     if ~tau_ok
    %         warning('tau_pos ≤ 0 detected – restarting (attempt %d/%d)…',...
    %             tau_iter, maxTauIter);
    %     end
    % end
    % 
    % if ~tau_ok
    %     error('Failed to obtain strictly positive tau_pos after %d attempts.', maxTauIter);
    % end

    %my_data.EVT_tau = tau_path;     % ----> use the *validated* τ‑path
    tau_path = EVT_OPTIONS.EXTERNAL_TAU;

    %% -------- Tail‑index estimation (unchanged) -------------------------
    tailMult = tern(S.lower_tail,-1,1);     % flip for upper EVT tail
    y_pos    = tailMult*my_data.y;
    tau_pos  = tailMult*tau_path;
    POTidx   = find(y_pos > tau_pos);
    POT01    = y_pos > tau_pos;
    POT01    = POT01(POTidx);
    ntstar   = cumsum(POT01);
    POTratio = ntstar ./ POTidx;
    POT      = y_pos(POTidx) ./ tau_pos(POTidx) - 1;

    theta0  = -7; if ~EVT_OPTIONS.FIXED_OMEGA, theta0=[theta0;-4]; end
    objTail = @(th) tail_filter(POT, par_trafo_tail(th,EVT_OPTIONS).omega, 1, par_trafo_tail(th,EVT_OPTIONS).alpha, mean(log1p(POT(1:min(50,length(POT)))))).llik/numel(POT);
    if exist('fminunc','file')
        opts=optimoptions('fminunc','Algorithm','quasi-newton','Display','off','MaxIter',1000,'TolFun',1e-10);
        thetaStar=fminunc(objTail,theta0,opts);
    else
        opts=optimset('Display','off','MaxIter',1000,'TolX',1e-6); thetaStar=fminsearch(objTail,theta0,opts);
    end
    parTail = par_trafo_tail(thetaStar,EVT_OPTIONS);
    f_t     = tail_filter(POT,parTail.omega,1,parTail.alpha,mean(log1p(POT(1:min(50,length(POT)))))).f_out;
    idxMap  = cumsum(double(y_pos>tau_pos)); idxMap(idxMap<1)=1;
    my_data.EVT_ft = f_t(idxMap);
    my_data.POTratio = POTratio(idxMap);

    %% ---- VaR / EL for requested extreme alphas -----------------------
    for a = EVT_OPTIONS.ALPHAS_EXTREME
        %VaR = tau_path .* ( (a/kappa).^ -my_data.EVT_ft );
        VaR = tau_pos .* ( (a./my_data.POTratio).^ -my_data.EVT_ft );
        EL  = VaR ./ (1-my_data.EVT_ft); EL(my_data.EVT_ft>=1)=NaN;
        my_data.(sprintf('EVT_VaR_alpha%g',a)) = VaR;
        my_data.(sprintf('EVT_EL_alpha%g',a))  = EL;
    end

    %out = struct('my_data',my_data,'tau_path',tau_path,'tail_par',parTail);
    out = struct('my_data',my_data,'tau_path',tau_pos,'tail_par',parTail);
end
