%% ======================================================================
function ll = local_tau_filter(y, x, kappa, steep, sharp)
    if nargin<4, steep = 3; end
    if nargin<5, sharp=false; end
    f1 = quantile(y, 1-kappa);
    p  = par_trafo_tau(x);
    out = dynamic_tau_filter(y, p.omega, p.beta, p.alpha1, p.alpha2, f1, kappa, steep, sharp);
    ll = out.llik;
end
