function v = par_trafo_tail(x, EVT)
    if EVT.FIXED_OMEGA
        omega = EVT.FIXED_OMEGA_VALUE;
        beta  = 1;
        alpha = 1/(1+exp(-x(1)));
    else
        alpha = 1/(1+exp(-x(1)));
        omega = exp(x(2));
        beta  = 1;
    end
    v = named([omega;beta;alpha], {'omega','beta','alpha'});
end
