%% ----------------------------------------------------------------------
function v = par_trafo_tau(x)
    v = [ x(1);                        % omega (unrestricted)
          1./(1+exp(-x(2)));           % beta   (0,1)
          + 5./(1+exp(-x(3)));          % alpha1 (0,5)
         -5 +  10./(1+exp(-x(4))) ];    % alpha2 (-5,5)
    v = named(v, {'omega','beta','alpha1','alpha2'});
end