%% ======================================================================
% Tail‑index dynamic filter (score‑driven)                                 
%% ======================================================================
function res = tail_filter(POT, omega, beta, alpha, f1)
    T = numel(POT); f = zeros(T,1);
    for t = 1:T
        f(t) = f1;
        f1   = omega + beta*f1 + alpha*(log1p(POT(t)) - f1);
    end
    ll_t = log(f) + (1 + 1./f) .* log1p(POT);
    ll   = sum(ll_t);
    if ~isfinite(ll), ll = 1e10; end
    res = struct('llik',ll,'llik_t',ll_t,'f_out',f);
end