%%%%%% Simulation: First experiment - Gaussian GARCH(1,1) 
% We generate x_t from a mixture distribution with k = 10%
% We draw with p = 1-k from a Gaussian GARCH(1,1) 
% With probability k we draw from the conditional GPD with TV-parameter f_t

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% GARCH (1,1) Parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%            ETH       BTC       EURUSD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  omega    0.011685   0.010433  0.007253 
%  alpha[1] 0.055861   0.083364  0.071201
%  beta[1]  0.934792   0.907590  0.924666

clear 
clc

%% Tail percentages -------------------------------------------------------
alpha_tail     = 0.10;   % Threshold tail (tau)
alphas_extreme = [];   % Extreme tail for VaR / EL
lower_tail  = false;

%% EVT filter options -----------------------------------------------------
s_EVT_OPTIONS1 = struct( ...
    "FIXED_OMEGA",      false, ...
    "FIXED_OMEGA_VALUE",0, ...
    "BANDS_RAW",        false, ...
    "BANDS_NRSIMS",     0, ...
    "BANDS_PCT",        0.75, ...
    "TAU_TAIL_PCT",     alpha_tail, ...
    "ALPHAS_EXTREME",   alphas_extreme, ...
    "EXTERNAL_TAU",     [], ... % overwritten later
    "set_seed",         1234);

%% EVT filter options -----------------------------------------------------
s_EVT_OPTIONS2 = struct( ...
    "FIXED_OMEGA",      true, ...
    "FIXED_OMEGA_VALUE",0, ...
    "BANDS_RAW",        false, ...
    "BANDS_NRSIMS",     0, ...
    "BANDS_PCT",        0.75, ...
    "TAU_TAIL_PCT",     alpha_tail, ...
    "ALPHAS_EXTREME",   alphas_extreme, ...
    "EXTERNAL_TAU",     [], ... % overwritten later
    "set_seed",         1234);

%% EVT filter options -----------------------------------------------------
s_EVT_OPTIONS3 = struct( ...
    "FIXED_OMEGA",      true, ...
    "FIXED_OMEGA_VALUE",10e-7, ...
    "BANDS_RAW",        false, ...
    "BANDS_NRSIMS",     0, ...
    "BANDS_PCT",        0.75, ...
    "TAU_TAIL_PCT",     alpha_tail, ...
    "ALPHAS_EXTREME",   alphas_extreme, ...
    "EXTERNAL_TAU",     [], ... % overwritten later
    "set_seed",         1234);
    

%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Simulation Parameters

TTtot = [5000, 10000, 25000, 50000];

i = 4;

TT = TTtot(i);
M = 100;

estim_par = NaN(M, 2);
estim_noOmega_par = NaN(M, 1);
estim_fixedOmega_par = NaN(M, 1);

estim_f = NaN(TT, M);
estim_noOmega_f = NaN(TT, M);
estim_fixedOmega_f = NaN(TT, M);

ff_t = NaN(TT, M);

k = 0.90;

% True DGP parameters
omega_g = 0.01;
alpha_g = 0.07;
beta_g = 0.92;

parameters_g = [omega_g alpha_g beta_g];

omega_f = 1.5e-5;
alpha_f = 0.01;

parameters_f= [omega_f alpha_f];

% Generating Data

for m = 1:M
    
    % Simulate Gaussian GARCH(1,1)
    [yg(:,m), ht(:,m)] = tarch_simulate(TT,parameters_g,1,0,1,'NORMAL',2);
    tau_t(:,m) = sqrt(ht(:,m)) .* norminv(k);
    
    % Simulate GPD with Time-Varying f_t
    epsi = exprnd(1, TT, 1);
    f_t(:,m) = zeros(TT, 1);
    yf(:,m) = zeros(TT, 1);
    
    ff = 0.7; %omega_f/alpha_f;
    %yf(1,m) = (exp(f_t(1,m) * epsi(1)) - 1);
    
    llik = 0;

    for tt = 1:TT

        if yg(tt,m) - tau_t(tt,m) > 0
            
            yg(tt,m) = tau_t(tt,m) * (exp(ff * epsi(tt)));
              
            f_t(tt,m) = ff;
            %ff = omega_f + ff +...
             %    alpha_f * (log(yg(tt,m)/tau_t(tt,m)) - ff);
             ff = omega_f + ff + alpha_f * ff * ( epsi(tt) - 1 );

        else 
            
            f_t(tt,m) = ff;
            ff = ff;

        end
    
    end

    % Estimates
    s_EVT_OPTIONS1.EXTERNAL_TAU = tau_t(:,m);
    s_EVT_OPTIONS2.EXTERNAL_TAU = tau_t(:,m);
    s_EVT_OPTIONS3.EXTERNAL_TAU = tau_t(:,m);

    my_data.y  = yg(:,m);              

    
    my_data1_EVT = estimate_full_model(my_data, s_EVT_OPTIONS1, ...
                              "verbosity", 0, "lower_tail", lower_tail);
    my_data2_EVT = estimate_full_model(my_data, s_EVT_OPTIONS2, ...
                              "verbosity", 0, "lower_tail", lower_tail);
    my_data3_EVT = estimate_full_model(my_data, s_EVT_OPTIONS3, ...
                              "verbosity", 0, "lower_tail", lower_tail);

    estim_par(m, :) = [my_data1_EVT.tail_par.omega, my_data1_EVT.tail_par.alpha];
    estim_f(:, m) = my_data1_EVT.my_data.EVT_ft;

    estim_noOmega_par(m, :) = [my_data2_EVT.tail_par.alpha];
    estim_noOmega_f(:, m) = my_data2_EVT.my_data.EVT_ft;

    estim_fixedOmega_par(m, :) = [my_data3_EVT.tail_par.alpha];
    estim_fixedOmega_f(:, m) = my_data3_EVT.my_data.EVT_ft;

    % True
    Tstar_true(m) = length(f_t(yg(:,m)>tau_t(:,m)));
    ff_t(1:Tstar_true(m), m) = f_t(yg(:,m)>tau_t(:,m), m);

end

if i == 1
    estim_ALL_omega5000 = [estim_par(:,1)];
    estim_ALL_alpha5000 = [estim_par(:,2), estim_noOmega_par(:,1), estim_fixedOmega_par(:,1)];
    estim_ALL_ft5000 = [estim_f, estim_noOmega_f, estim_fixedOmega_f];
    true_ft5000 = f_t;
    true_fft5000 = ff_t;
    clearvars -except estim_ALL_omega5000 estim_ALL_alpha5000 estim_ALL_ft5000 true_ft5000 true_fft5000 yg tau_t Tstar_true
    save MC_simulations_SC1_5000
end

if i == 2
    estim_ALL_omega10000 = [estim_par(:,1)];
    estim_ALL_alpha10000 = [estim_par(:,2), estim_noOmega_par(:,1), estim_fixedOmega_par(:,1)];
    estim_ALL_ft10000 = [estim_f, estim_noOmega_f, estim_fixedOmega_f];
    true_ft10000 = f_t;
    true_fft10000 = ff_t;
    clearvars -except estim_ALL_omega10000 estim_ALL_alpha10000 estim_ALL_ft10000 true_ft10000 true_fft10000 yg tau_t Tstar_true
    save MC_simulations_SC1_10000
end

if i == 3
    estim_ALL_omega25000 = [estim_par(:,1)];
    estim_ALL_alpha25000 = [estim_par(:,2), estim_noOmega_par(:,1), estim_fixedOmega_par(:,1)];
    estim_ALL_ft25000 = [estim_f, estim_noOmega_f, estim_fixedOmega_f];
    true_ft25000 = f_t;
    true_fft25000 = ff_t;
    clearvars -except estim_ALL_omega25000 estim_ALL_alpha25000 estim_ALL_ft25000 true_ft25000 true_fft25000 yg tau_t Tstar_true 
    save MC_simulations_SC1_25000
end

if i == 4
    estim_ALL_omega50000 = [estim_par(:,1)];
    estim_ALL_alpha50000 = [estim_par(:,2), estim_noOmega_par(:,1), estim_fixedOmega_par(:,1)];
    estim_ALL_ft50000 = [estim_f, estim_noOmega_f, estim_fixedOmega_f];
    true_ft50000 = f_t;
    true_fft50000 = ff_t;
    clearvars -except estim_ALL_omega50000 estim_ALL_alpha50000 estim_ALL_ft50000 true_ft50000 true_fft50000 yg tau_t Tstar_true
    save MC_simulations_SC1_50000
end
