%% ======================================================================
function ret = PZC_filter(ydata, omega, A, B, f0, alpha, smoothing, shortFlag)
    if nargin<8, shortFlag=false; end
    if any(structfun(@isempty,struct('A',A,'B',B,'omega',omega)))
        ret = fail(shortFlag); return; end

    n = numel(ydata); f_vals=zeros(n,2); f=f0(:);
    for t=1:n
        f_vals(t,:)=f'; if max(f)>=0, ret=fail(shortFlag); return; end
        s  = stepfun_smooth(ydata(t),f(1),smoothing);
        g  = [-f(1)*(s-alpha);  s*ydata(t)/alpha - f(2)];
        f  = omega(:) + B*f + A*g; if any(~isfinite(f)), ret=fail(shortFlag); return; end
    end

    obj_t = LFZ0_obj(ydata, f_vals(:,1), f_vals(:,2), alpha, smoothing);
    v = isfinite(obj_t);
    if ~any(v), ret=fail(shortFlag); return; end
    obj = mean(obj_t(v));
    if shortFlag, ret=obj; else, ret=struct('obj',obj,'VaR',f_vals(:,1),'EL',f_vals(:,2)); end
end
