%% ======================================================================
% TRANSFORMS + helpers
%% ======================================================================
function out = get_parameters(theta,dA,dB,rw,reverse)
    if nargin<5, reverse=false; end
    ta=@(x)0.1*(exp(x)-1)./(exp(x)+1); ita=@(x)log((1+x/0.1)./(1-x/0.1));
    tb=@(x)(exp(x)-1)./(exp(x)+1);      itb=@(x)log((1+x)./(1-x));
    to=@(x)10*(exp(x)-1)./(exp(x)+1);   ito=@(x)log((1+x/10)./(1-x/10));
    if ~reverse
        i=1; omega=to(theta(i:i+1)); i=i+2;
        if dA,  A=diag(ta(theta(i:i+1))); i=i+2; else, A=reshape(ta(theta(i:i+3)),2,2)'; i=i+4; end
        if rw  , B=eye(2);
        else, if dB, B=diag(tb(theta(i:i+1))); else, B=reshape(tb(theta(i:i+3)),2,2)'; end
        end
        out=struct('omega',omega,'A_mat',A,'B_mat',B);
    else
        th = ito(theta.omega(:));
        if dA
            th = [th; ita(diag(theta.A_mat))];
        else
            th = [th; ita(theta.A_mat(:))];
        end
        if ~rw
            if dB
                th = [th; itb(diag(theta.B_mat))];
            else
                th = [th; itb(theta.B_mat(:))];
            end
        end
        out = th;
    end
end